#include "Main.h"

void shipsToPlaceInit(Game *g)
{
	ShipsToPlace *sh;

	assert (g != NULL);

	sh = (ShipsToPlace*) malloc(sizeof(ShipsToPlace));
	g->shipsToPlace = sh;
	
	sh->count = numSizeFiveShips;
	sh->length = 5;
	sh->next = (ShipsToPlace*) malloc(sizeof(ShipsToPlace));

	sh = sh->next;
	sh->count = numSizeFourShips;
	sh->length = 4;
	sh->next = (ShipsToPlace*) malloc(sizeof(ShipsToPlace));

	sh = sh->next;
	sh->count = numSizeThreeShips;
	sh->length = 3;
	sh->next = (ShipsToPlace*) malloc(sizeof(ShipsToPlace));
	
	sh = sh->next;
	sh->count = numSizeTwoShips;
	sh->length = 2;
	sh->next = NULL;
}

void shipsToPlaceClose(Game *g)
{
	ShipsToPlace *sh, *osh;

	assert(g != NULL);

	sh = g->shipsToPlace;
	while (sh != NULL)
	{
		osh = sh;
		sh = sh->next;
		free(osh);
	}
	g->shipsToPlace = NULL;
}

int placeShip(unsigned char *map, int shipSize, int px, int py, Orientation ori)
{
	int x,y,i,j,sdvar, *dvar, *ovar;

	if (!XYVALID(px,py)) return 0;
	if (shipSize <= 0 || shipSize > 5) return 0;
	if (map == NULL) return 0;

	x = px;
	y = py;
	if (ori == vertical) {dvar = &y; ovar = &x;}
	else {dvar = &x; ovar = &y;}
	
	// stop if cannot place
	for (i=0; i<shipSize; i++)
	{
		if (!XYVALID(x,y)) return 0;
		if (mapGet(map,x,y) & (F_SHIP_PRESENT | F_NEIGHBOURING) ) return 0;
		(*dvar)++;
	}

	// place the ship
	x = px;
	y = py;
	for (i=0; i<shipSize; i++)
	{
		mapSetF(map, x, y, F_SHIP_PRESENT );
		(*dvar)++;
	}

	// mark neighbouring blocks
	x = px-1;
	y = py-1;
	sdvar = *dvar;
	for (i=-1; i<=1; i++)
	{
		for (j=-1; j<=shipSize; j++)
		{
			if (XYVALID(x,y)) mapSetF(map, x,y, F_NEIGHBOURING );
			(*dvar)++;
		}
		*dvar = sdvar;
		(*ovar)++;
	}

	return 1;
}

int areThereAnyMoreShipsLeftToPlace(Game *g)
{
	ShipsToPlace *sh;

	assert(g != NULL);

	sh = g->shipsToPlace;
	while (sh != NULL)
	{
		if (sh->count) return 1;
		sh = sh->next;
	}
	return 0;
}

void printNumberOfShipsToPlace(Game *g)
{
	ShipsToPlace *sh;

	assert(g != NULL);

	sh = g->shipsToPlace;
	while (sh != NULL)
	{
		if (sh->count)
			printfCon (&(g->con), "You have %d %d-Master%s left to place\n", sh->count, sh->length,
				sh->count == 1? "" : "s");
		sh = sh->next;
	}
}

int parseShipPlacementCommand(Game *g, char *cmd, int cmdlen)
{
	char *pc = cmd;
	char *cstart = cmd;
	int state = 0;
	int x,y,shiplen, lenfound;
	Orientation ori;
	ShipsToPlace *sh;

	assert(cmd != NULL);
	assert(g != NULL);
	assert(g->mapPlayer != NULL);

	stringToLower(cmd, strlen(cmd));

	while (cmdlen > 0)
	{
		if (*pc == ' ' || *pc == 0x0a)
		{
			if (pc == cstart) // ignore extra spaces
			{
				cstart = pc = pc + 1;
				continue;
			}
			else
			{
				if (state == 0) // state 0 - read grid square
				{
					if (!parseGridSquare(cstart, pc-cstart, &x, &y)) return 0;
				}
				else if (state == 1) // read ship size
				{
					if (0 == parseNumber(cstart, pc-cstart, &shiplen)) return 0;
				}
				else if (state == 2) // read orientation
				{
					if (*cstart == 'h') ori = horizontal;
					else if (*cstart = 'v') ori = vertical;
					else return 0;
					state = 3;
					break; // quit while loop - we have everything
				}
				state++;
				cstart = pc = pc+1;
				continue;
			}
		}
		if (*pc == '\0') break;
		pc++;
		cmdlen--;
	}

	if (state != 3) return 0;
	if (!XYVALID(x,y)) return 0;
	if (shiplen < 0 || shiplen > maxShipLen) return 0;

	sh = g->shipsToPlace;
	lenfound = 0;
	while (sh != NULL)
	{
		if (sh->length == shiplen)
		{
			lenfound = 1;
			if (sh->count == 0) return 0;
			else break;
		}
		sh = sh->next;
	}

	if (!lenfound) return 0;

	if (placeShip(g->mapPlayer, shiplen, x, y, ori))
	{
		sh->count--; // sh still points to the relevant shipToPlace object
		return 1;
	}
	return 0;
}

void placeOpponentsShips(Game *g, unsigned char *map)
{
	int x, y, failsafe;
	Orientation ori;
	ShipsToPlace *sh;

	assert(g != NULL);
	if (g->shipsToPlace == NULL) shipsToPlaceInit(g);

	sh = g->shipsToPlace;
	while (sh != NULL)
	{
		failsafe = 0;
		// basically, keep guessing random numbers until all ships are placed
		while (sh->count > 0)
		{
			if (rand() % 100 < 50) ori = horizontal;
			else ori = vertical;
			x = rand() % gameWidth;
			y = rand() % gameHeight;
			
			if (placeShip(map, sh->length, x, y, ori)) sh->count--;
			else failsafe++;

			if (failsafe > 1000)
			{
				// sometimes it's possible that the placement algorithm
				// gets itself into a situation without exit - all the spots
				// are occupied, but there are still some more ships left to place
				// if that happens, we should simply start over
				shipsToPlaceClose(g);
				placeOpponentsShips(g, map);
				return;
			}
		}
		sh = sh->next;
	}

	// de-allocate the shipsToPlace object. It will be allocated again
	// if either the player or the computer want to place ships
	// again.
	shipsToPlaceClose(g);
}

void placePlayersShips(Game *g)
{
	char buf[256];
	int res;
	WinConsole *con;

	assert(g != NULL);
	con = &(g->con);
	if (g->shipsToPlace == NULL) shipsToPlaceInit(g);

	printMapWin(g, playerPlacement, opponent);
	printfCon (con, "\nPlace your ships. Syntax: <Square> <length> <h|v>\n"
		"Example: \"A1 3 v\" places 3-mast vertically on grid A1. Type '-' to exit.\n");
	printNumberOfShipsToPlace(g);
	printfCon (con, "> ");
	do
	{
		//fgets(buf, sizeof(buf), stdin);
		//printfCon(&(g->con), buf);
		//g->con.consoleX = 0;
		//if (*buf == '-')
		//	exit(0);
		consoleInputWin(&(g->con), buf, sizeof(buf));

		res = parseShipPlacementCommand(g, buf, strlen(buf));
		printMapWin(g, playerPlacement, opponent);
		if (res == 0) printfCon (con, "Placement failed.\n");
		else printfCon (con, "Placement successful.\n");
		printNumberOfShipsToPlace(g);
		printfCon(con, "\n> ");
	}
	while (areThereAnyMoreShipsLeftToPlace(g));

	shipsToPlaceClose(g);
}